using System;

	/// <summary>
	/// ByteBitWise, WordBitWise, DWordBitWise are classes to support
	/// shl and shr operations at byte, word (UInt16) or DWORD (UInt32) level not
	/// defined for C#'s .cs by default.
	/// made by Endre I. Simay,
	/// Hungary
	/// </summary>
public class ByteBitWise {
	byte [] ext;
	public ByteBitWise () {
		ext =new byte [8];
		ext[0]=1;
		for (int i=1; i<8; i++) // {1, 2, 4, 8, 16, 32, 64, 128};
		{
			ext[i]=(byte)(ext[i-1]*2);
		}
	}
	public byte shr (byte basic, byte n) {
		return (byte)(basic/ext[n & (8-1)]);
	}

	public byte shl (byte basic, byte n) {
		return (byte)(basic*ext[n & (8-1)]);
	}
}

public class WordBitWise {
	UInt16 [] ext;
	public WordBitWise () {
		ext =new UInt16 [16];
		ext[0]=1;
		for (int i=1; i<16; i++) // {1, 2, 4, 8, 16, 32, 64, 128...};
		{
			ext[i]=(UInt16)(ext[i-1]*2);
		}
	}
	public UInt16 shr (UInt16 basic, UInt16 n) {
		return (UInt16)(basic/ext[n & (16-1)]);
	}

	public UInt16 shl (UInt16 basic, UInt16 n) {
		return (UInt16)(basic*ext[n & (16-1)]);
	}
}

public class DWordBitWise {
	UInt32 [] ext;
	public DWordBitWise () {
		ext =new UInt32 [32];
		ext[0]=1;
		for (int i=1; i<32; i++) // {1, 2, 4, 8, 16, 32, 64, 128...};
		{
			ext[i]=(UInt32)(ext[i-1]*2);
		}
	}
	public UInt32 shr (UInt32 basic, UInt32 n) {
		return (UInt32)(basic/ext[n & (32-1)]);
	}

	public UInt32 shl (UInt32 basic, UInt32 n) {
		return (UInt32)(basic*ext[n & (32-1)]);
	}
}

